function [skt] = sktopen_noreg(remoteip,socket,port,baud);
%[skt] = sktopen(remoteip,socket);
%[skt] = sktopen(remoteip);
%[skt] = sktopen( '192.168.1.4' ,1000);
%[skt] = sktopen( '1.4','1.1','COM4',230400 ); for serial version
%[skt] = sktopen(remoteip,localip,comport,baudrate);
% To close serial port - skt.ser=1;
% Open udp socket and get registry info from PIC/ARM
% updated for octave 3-Feb-2018 - Ian Stothers
% updated for compatibility with 32 bit mcu octave 25/may/2020 - Ian Stothers


if (nargin==0)
   remoteip='192.168.1.4';
   nargin=1;
endif

if(max(size(find(remoteip=='.')))==1)
 if (nargin==1)
   skt=sersktopen(remoteip);
 endif
 if (nargin==2)
    skt=sersktopen(remoteip,socket);
 endif
 if (nargin==3)
    skt=sersktopen(remoteip,socket,port);
 endif
 if (nargin==4)
    skt=sersktopen(remoteip,socket,port,baud);
 endif
 return;
endif

if((exist('udpport')~=3))
    pkg load instrument-control; % load the instrument control octave library
end
if (exist('udpport')~=3)
  error('Needs instrument-control toolbox');
  return;
endif
Broadcast = 0;
if (strfind(remoteip,'255')>0)
   Broadcast=1;
endif

if(nargin==2)
 skt.ip=remoteip;
 skt.udp = udpport('localport',socket);
else
 if (nargin==1)
  skt.ip = remoteip;
  minport=32000; % search socket range
  maxport=33000;
  socket=minport;
  gotone=0;
  while (gotone==0)
   try
    skt.udp = udpport('localport',socket);
    gotone=1;
   catch
    socket=socket+1;
    if (socket>maxport)
      error('no socket found');
    end
   end
  endwhile
 else
  error('sktopen needs 1 or 2 arguments - type help sktopen for details');
 endif
endif
skt.udp.Timeout=0.2 ;

skt.port=socket;

if (Broadcast==1)
  set(skt.udp,"EnableBroadcast",Broadcast);
endif

endfunction



function [skt] = sersktopen(remoteip,localip,comport,baudrate);
%[skt] = sersktopen(remoteip,localip,comport,baudrate);
%[skt] = sktopen( '1.4','1.1','COM4',230400 );
% Open serial socket and get registry info from STM
%  5-Jun-2023 - Ian Stothers

pkg unload instrument-control
pkg load instrument-control

if((exist('udpport')~=3))
    pkg load instrument-control; % load the instrument control octave library
end
if (exist('udpport')~=3)
  error('Needs instrument-control toolbox');
  return;
 end

if(nargin<4)
 baudrate=230400;
endif
if(nargin<1)
 skt.remoteip='1.4';
else
 skt.remoteip=remoteip;
endif
if(nargin<2)
 skt.localip='1.1';
else
 skt.localip=localip;
endif
if(nargin<3)
 a=serialportlist;
 comport=char(a(end,1));
endif

skt.ip=skt.remoteip;

if(ischar(comport))
 skt.ser = serialport(comport,baudrate);
else
 skt.ser=comport;
endif
skt.ser.Timeout=0.100 ;

setDTR(skt.ser,0); %enable line drivers
endfunction

